#ifndef _DX_VOS_INT_H
#define _DX_VOS_INT_H

/*! \file DX_VOS_Int.h
    \brief This file enables interrupt handling - blocking and unblocking 
*/

#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Errors.h"

#ifdef __cplusplus
extern "C"
{
#endif
				  
/*************************** DEFINES ***********************/





/*************************** Typedefs *********************/


#define DX_VOS_INT_DISABLE	0xFFFFFFFF
#define DX_VOS_INT_ENABLE	0x0


  

/*!
 \brief 
 DX_VOS_InterruptControl () - control the interrups - set the mask 
 @param[in] aIntCtrlMask - the requested masking of the interrupts 
 @param[in] aPrevMask - the previous mask
 @return On success the function returns DX_SUCCESS. 
 	                        On error,
 	                        if argument equal NULL, DX_BAD_ARGUMENTS is returned
 	                        if create operation fails, DX_VOS_FAIL is returned
 **/

DxVosResult_t DX_VOS_InterruptControl (DxUint32  aIntCtrlMask, DxUint32 *aPrevMask);



#ifdef  __cplusplus
}
#endif


#endif /* ifndef _DX_VOS_INT_H */
